#!/bin/bash
export datasets1="Cora CiteSeer PubMed cs wikics"
export datasets2="physics OGBN-Arxiv"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export missing_rates_reverse="1.0 0.9999 0.999 0.99 0.9 0.8 0.7 0.6 0.5 0.4 0.3 0.2 0.1 0.0"
export missing_rates_reverse_2="0.7 0.6 0.5 0.4 0.3 0.2 0.1 0.0"
export missing_rates_tmp="0.0 0.9999 1.0"
export lambda_list_1="0.00001"
export lambda_list_2="0.00001 0.0001 0.001 0.01 0.1 1 10"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export attn_type="random sum mean concat"
export gpu=7

# Mag - uniform
for missing_rate in $missing_rates_tmp
do
python main.py --dataset OGBN-Mag --missing_type uniform --missing_rate ${missing_rate} --embedder GOODIE_2 --lp_alpha 0.8 --lamb 1 --n_runs 1 --gpu ${gpu}
done

python main.py --dataset OGBN-Mag --missing_type structural --missing_rate 0.9999 --embedder GOODIE_2 --lp_alpha 0.8 --lamb 1 --n_runs 1 --gpu ${gpu}

# Products - uniform
for missing_rate in $missing_rates_tmp
do
python main.py --dataset OGBN-Products --missing_type uniform --missing_rate ${missing_rate} --embedder GOODIE_2 --lp_alpha 0.8 --lamb 1 --n_runs 1 --gpu ${gpu}
done

python main.py --dataset OGBN-Products --missing_type structural --missing_rate 0.9999 --embedder GOODIE_2 --lp_alpha 0.8 --lamb 1 --n_runs 1 --gpu ${gpu}
